#include <cassert>
#include <cstdio>
#include <ctime>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <algorithm>
#include <iostream>
#include <set>
#include <map>
#include <vector>
#include <queue>
#include <deque>
using namespace std;
#define pb push_back
#define mp make_pair
#define fs first
#define sc second
#define sz(a) ((int) (a).size())
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#define int64 long long
#define ldb long double
const double pi = acos(-1.0);

const int N = (int) 1e5;
int x[N], y[N], n, m, p[N], u, v;
vector< pair<int, int> > adj[N];
double ans = 0;

pair<int, int> get(int x) {
	if (x == 1) return mp(2, 3);
	if (x == 2) return mp(1, 3);
	assert(x == 3);
	return mp(1, 2);
}

double len(double x, double y) {
	return sqrt(x * x + y * y);
}

double angle(int i, int j, int k) {
	int x1 = x[j] - x[i], y1 = y[j] - y[i];
	int x2 = x[k] - x[i], y2 = y[k] - y[i];
	return pi - acos((x1 * x2 + y1 * y2) / len(x1, y1) / len(x2, y2));
}

int df(int x) {
	return (x == p[x]) ? x : (p[x] = df(p[x]));
}

vector< pair<double, pair<int, int> > > edges;

void add_edge(int u, int v, double w) {
	edges.pb(mp(w, mp(u, v)));
}

int main() {
	//assert(freopen("input.txt", "r", stdin));
	//assert(freopen("output.txt", "w", stdout));
	scanf("%d%d", &n, &m);
	for (int i = 0; i < n; ++i)
		scanf("%d%d", &x[i], &y[i]);
	for (int i = 0; i < m; ++i)
		scanf("%d%d", &u, &v), adj[u].pb(mp(v, i)), adj[v].pb(mp(u, i)), p[i] = i;
	for (int i = 0; i < n; ++i) {
		if (sz(adj[i]) == 2) {
			ans += angle(i, adj[i][0].fs, adj[i][1].fs);
			add_edge(adj[i][0].sc, adj[i][1].sc, 0);
		} else {
			vector< pair<double, int> > super;
			for (int j = 1; j < sz(adj[i]); ++j) {
				pair<int, int> other = get(j);
				super.pb(mp(angle(i, adj[i][0].fs, adj[i][j].fs) + angle(i, adj[i][other.fs].fs, adj[i][other.sc].fs), j));
			}				
			sort(super.begin(), super.end());
			int j = super[0].sc;
			ans += super[0].fs;
			pair<int, int> other = get(j);
			add_edge(adj[i][0].sc, adj[i][j].sc, 0);
			add_edge(adj[i][other.fs].sc, adj[i][other.sc].sc, 0);
			add_edge(adj[i][0].sc, adj[i][other.fs].sc, super[1].fs - super[0].fs);
		}
	}
	sort(edges.begin(), edges.end());
	for (int i = 0; i < sz(edges); ++i) {
		int u = df(edges[i].sc.fs), v = df(edges[i].sc.sc);
		if (u != v) {
			p[u] = v;
			ans += edges[i].fs;
		}
	}
	printf("%.10lf\n", ans);
	return 0;
}